/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.enchant;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import lotr.common.LOTRDamage;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentBane;
import lotr.common.enchant.LOTREnchantmentType;
import lotr.common.item.LOTRItemBlowgun;
import lotr.common.item.LOTRItemBow;
import lotr.common.item.LOTRItemCrossbow;
import lotr.common.item.LOTRWeaponStats;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketWeaponFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;

public class LOTREnchantmentRangedProvident
extends LOTREnchantment {
    private boolean compatibleBane = true;
    private boolean compatibleOtherSpecial = false;

    public LOTREnchantmentRangedProvident(String s) {
        super(s, new LOTREnchantmentType[]{LOTREnchantmentType.RANGED_LAUNCHER2});
        this.setValueModifier(3.0f);
        this.setBypassAnvilLimit();
    }

    public LOTREnchantmentRangedProvident setIncompatibleBane() {
        this.compatibleBane = false;
        return this;
    }

    public LOTREnchantmentRangedProvident setCompatibleOtherSpecial() {
        this.compatibleOtherSpecial = true;
        return this;
    }

    @Override
    public String getDescription(ItemStack itemstack) {
        if (LOTRWeaponStats.isMeleeWeapon(itemstack)) {
            return StatCollector.func_74837_a((String)("lotr.enchant." + this.enchantName + ".desc.melee"), (Object[])new Object[0]);
        }
        return StatCollector.func_74837_a((String)("lotr.enchant." + this.enchantName + ".desc.ranged"), (Object[])new Object[0]);
    }

    @Override
    public boolean isBeneficial() {
        return true;
    }

    @Override
    public boolean canApply(ItemStack itemstack, boolean considering) {
        if (itemstack.func_77973_b() instanceof LOTRItemCrossbow) {
            return false;
        }
        return itemstack.func_77973_b() instanceof LOTRItemBow || itemstack.func_77973_b() instanceof LOTRItemBlowgun || itemstack.func_77973_b() instanceof ItemBow;
    }

    @Override
    public boolean isCompatibleWith(LOTREnchantment other) {
        if (!this.compatibleBane && other instanceof LOTREnchantmentBane) {
            return false;
        }
        return this.compatibleOtherSpecial || !(other instanceof LOTREnchantmentRangedProvident) || ((LOTREnchantmentRangedProvident)other).compatibleOtherSpecial;
    }

    public static int getFireAmount() {
        return 2;
    }

    public static void doPoisonAttack(EntityLivingBase entity) {
        if (entity instanceof EntityPlayerMP) {
            LOTRDamage.doFrostDamage((EntityPlayerMP)entity);
        }
        int duration = 2;
        entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, duration * 20, 1));
    }

    public static void doChillAttack(EntityLivingBase entity) {
        if (entity instanceof EntityPlayerMP) {
            LOTRDamage.doFrostDamage((EntityPlayerMP)entity);
        }
        int duration = 5;
        entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, duration * 20, 1));
        LOTRPacketWeaponFX packet = new LOTRPacketWeaponFX(LOTRPacketWeaponFX.Type.CHILLING, (Entity)entity);
        LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, LOTRPacketHandler.nearEntity((Entity)entity, 64.0));
    }
}

